/*
 *  Copyright 2003 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 *  
 */
/* "@(#) DDK 1.10.00.21 06-26-03 (ddk-b10)" */
#include <vport.h>
#include <vportdis.h>
#include <csl_edma.h>

#include "evmdm642_vdisparams.h"

#define LINE_SZ   240
#define NUM_LINES 320

VPORTDIS_Params EVMDM642_vDisParamsChan = {
    VPORT_MODE_RAW_16BIT, 	/* dmode:3       */
    VPORT_FLDOP_PROGRESSIVE,/* fldOp:3       */

    VPORT_SCALING_DISABLE, /* scale:1       */    
    VPORT_RESMPL_DISABLE,  /* resmpl:1      */      
    VPORTDIS_DEFVAL_ENABLE,/* defValEn:1    */
    VPORTDIS_BPK_10BIT_NORMAL, /*bpk10Bit:1 */
    
    VPORTDIS_VCTL1_AVID,  /* vctl1Config:2 */
    VPORTDIS_VCTL2_VSYNC,  /* vctl2Config:2 */
    VPORTDIS_VCTL3_CBLNK,    /* vctl3Config:1 */
    VPORTDIS_EXC_DISABLE,  /* extCtl:3      */
               
    289,                   /* frmHSize */
    332,                   /* frmVSize */

    0,                     /* imgHOffsetFld1 */
    0,                     /* imgVOffsetFld1 */
    LINE_SZ,               /* imgHSizeFld1   */
    NUM_LINES,             /* imgVSizeFld1   */
    
    0,                     /* imgHOffsetFld2 */
    0,                     /* imgVOffsetFld2 */
    0,               /* imgHSizeFld2   */
    0,             /* imgVSizeFld2   */

    1, 	                   /* hBlnkStart      */                    
    40,                    /* hBlnkStop       */                    
    
    1,                   /* vBlnkXStartFld1 */                    
    1,                     /* vBlnkYStartFld1 */                    
    41,                   /* vBlnkXStopFld1  */                    
    8,                    /* vBlnkYStopFld1  */                    
    
    0,                   /* vBlnkXStartFld2 */                    
    0,                   /* vBlnkYStartFld2 */                    
    0,                   /* vBlnkXStopFld2  */                    
    0,                   /* vBlnkYStopFld2  */                    
    
    0,                   /* xStartFld1 */                         
    0,                     /* yStartFld1 */                         
    
    0,                   /* xStartFld2 */                         
    0,                   /* yStartFld2 */                         

    40,                   /* hSyncStart */                         
    280,                   /* hSyncStop  */                         
            
    40,                   /* vSyncXStartFld1 */                    
    8,                     /* vSyncYStartFld1 */                    
    280,                   /* vSyncXStopFld1  */                    
    327,                     /* vSyncYStopFld1  */                    

    0,                   /* vSyncXStartFld2 */                    
    0,                   /* vSyncYStartFld2 */                    
    0,                   /* vSyncXStopFld2  */                    
    0,                   /* vSyncYStopFld2  */                    

    0,                    /* yClipLow        */                    
    255,                   /* yClipHigh       */                    
    
    0,                    /* cClipLow        */                    
    255,                   /* cClipHigh       */                    
    
    0x10,
    0x80,
    0x80,

    VPORTDIS_RGBX_DISABLE, /* RGB extract disable */
    1,                     /* incPix, for raw mode only */          
    (LINE_SZ>>3),          /*thrld     */

    3,                     /*numFrmBufs*/
    128,                     /*alignment */
    VPORT_FLDS_MERGED,     /*mergeFlds */
    NULL,                  /*segId     */            
    EDMA_OPT_PRI_HIGH,     /*edmaPri   */
    8                      /* irqId    */    
};

VPORT_PortParams EVMDM642_vDisParamsPort = {
    FALSE,                      /*  enableDualChan;     */ 
    VPORT_POLARITY_ACTIVE_HIGH, /* vport control pin 1 polarity    */
    VPORT_POLARITY_ACTIVE_HIGH, /* vport control pin 2 polarity    */
    VPORT_POLARITY_ACTIVE_HIGH, /* vport control pin 3 polarity    */
    INV,
    INV,
};

