******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for AM26LV31E
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2009, (C) COPYRIGHT 2009, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'am26lv31e.inc'
X__AM26LV31E X_1A X_1Y X_1Z G X_2Z X_2Y X_2A GND X_3A X_3Y X_3Z NG X_4Z X_4Y
+ X_4A VCC AM26LV31E
*** PULSE PARAMETERS ***
.param PFREQ1=10MEG $ 1st pulse (clk) frequency
.param PRFT19=2ns $ rise/fall time
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage
.param PVT='PVCC/2' $ input threshold voltage
.param PMAX=0NS $ max SPICE delay time
.param PRFT='(PRFT19/0.8)' $ convert rise/fall time to 100$
.param PPD1='(1/PFREQ1)' $ period of 1st pulse
.param PPW1='((PPD1 - (PRFT*2))/2)' $ pulse width of 1st pulse

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+PMAX+160n' $
.TRAN 0.05n 'PSTOP' 'PSTART' 0.05n
.PRINT TRAN v(DATA)

* SET CONTROL INPUTS TO ENABLE OUTPUT
VC0 G 0 pulse 'PVIN' 0 'PDELAY1' 'PRFT' 'PRFT' 78n 160n
VC1 NG 0 pulse 'PVIN' 0 'PDELAY1' 'PRFT' 'PRFT' 38n 80n


*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VI0 X_1A 0 pulse 'PVIN' 0 'PDELAY1' 'PRFT' 'PRFT' 18n 40n


* CHANGE TO THE OUTPUT NODE
RX_1Y X_1Y GND 50
RX_1Z X_1Z GND 50

* VOLTAGE SUPPLIES
.OPTION MAXMOS_DIM 15000

.param PVCC=3.3
.param PGND=0v
VVCC VCC 0 'PVCC'
VGND GND 0 'PGND'

.TEMP 40

* RESISTORS TO PREVENT DANGLING NODES
* R1G_1 X_1A 0 1G
* R1G_2 X_1Y 0 1G
* R1G_3 X_1Z 0 1G
* R1G_4 G 0 1G
R1G_5 X_2Z 0 1G
R1G_6 X_2Y 0 1G
R1G_7 X_2A 0 1G
* R1G_8 GND 0 1G
R1G_9 X_3A 0 1G
R1G_10 X_3Y 0 1G
R1G_11 X_3Z 0 1G
* R1G_12 NG 0 1G
R1G_13 X_4Z 0 1G
R1G_14 X_4Y 0 1G
R1G_15 X_4A 0 1G
* R1G_16 VCC 0 1G

.END
