
#include <system.h>

#define SCL_PORT_MASK 00001000b;
#define SDA_PORT_MASK 00010000b;


unsigned int outval[6];  //global data containing the sensed voltage and current returned by SM72442
unsigned char readval[9];

static unsigned char i2c_buffer[9]; //buffer used to send character to I2C port


void delay(void){
//    char a;
//    tmr2=0;  //should give 50us time delay
//    pir1=pir1&~00000010b;
//    a=pir1&00000010b;
//    while(a==0){
//    a=pir1&00000010b;
//    }
}
//this function waits for the SCL line to be released
void wait_scl(void){
    unsigned char data = portc&SCL_PORT_MASK;
    while (data == 0){
        data = portc&SCL_PORT_MASK;
    }
}
//this function waits for the SDA line to be released
void wait_sda(void){
    unsigned char data = portc&SDA_PORT_MASK;
    while (data == 0){
        data = portc&SDA_PORT_MASK;
    }
}
//release SDA line
void release_sda(void){

    trisc = trisc|SDA_PORT_MASK;
    	asm{
		nop
		nop
		nop
		nop
		}
}
//Forces SDA line low
void drop_sda(void){

    trisc=trisc&~SDA_PORT_MASK; 
    	asm{
		nop
		nop
		nop
		nop
		}   
}
//release SCL line
void release_scl(void){

    trisc = trisc|SCL_PORT_MASK;
   	asm{
		nop
		nop
		nop
		nop
		} 
}
//Forces SCL line low
void drop_scl(void){
    trisc = trisc&~SCL_PORT_MASK;
    	asm{
		nop
		nop
		nop
		nop
		}
}
//read the status of the SDA line
unsigned char read_sda(void){
    unsigned char data;
    data = portc&SDA_PORT_MASK;
    if (data != 0){
        return 1;
    }else{
        return 0;
    }
}
//----------------------------------------------------------------------
//Send a stop command over the I2C bus
void i2c_stop(void){
    //delay();
    release_scl();
    //delay();
    wait_scl();
    release_sda();
    //delay();
    wait_sda();
}
//issue a start command over the I2C bus
void i2c_start(void){
    i2c_stop();
    //delay();
    drop_sda();
    //delay();
    drop_scl();
    //delay();
}

void i2c_readstart(void){
    release_sda();
    //delay();
    wait_sda();
    release_scl();
    //delay();
    wait_scl();
    //delay();
    drop_sda();
    //delay();
    drop_scl();
    //delay();
}
//send data over the I2C line
int i2c_send(char data){
    int i;
    drop_scl();    
    for (i=0; i<8; i++)
    {
        if ((data & 0x80) != 0)
            release_sda();
        else
            drop_sda();

        //delay();    //*** this delay for debugging only. remove later.
        release_scl();
        //delay();
        wait_scl();
        drop_scl();
        //delay();
        data <<= 1;
    }
    release_sda();    //release SDA so slave can control it
    //delay();        //*** this delay for debugging only. remove later.
    release_scl();
    //delay();
    wait_scl();
    i = read_sda();    //read ACK pulse
    drop_scl();
    //delay();
    drop_sda();
    //delay();
    return i;        //return ACK value
}
//read one byte from I2C line
char i2c_rx(void){
    int i;
    char data=0;
    release_sda();    //release SDA so slave can control it
    //delay();        //*** this delay for debugging only. remove later.
    for (i=0;i<8;i++)
    {
        release_scl();
        //delay();
        wait_scl();
        data <<= 1;        
        data |= read_sda();
        drop_scl();
        //delay();
    }
    drop_sda();
    //delay();
    return data;        //return data byte
}

void send_nak(void){
    release_sda();
   // delay();
    wait_sda();
    release_scl();
    //delay();
    drop_scl();
    //delay();
    drop_sda();
    //delay();            //prepare to send STOP
}

void send_ack(void){
    drop_sda();        //should always be floating after a read anyway
    //delay();        //*** this delay for debugging only. remove later.
    release_scl();
    //delay();
    drop_scl();
    //delay();
}

void testi2c(void){
    int i, result;
    char readval;

    i2c_start();    //start a write cycle (just to set the address)
    result = i2c_send(0x02);//send write address
    if (result != 0)
    {
    //    return 1;
    }
    result = i2c_send(0x10);//address/command for read
    if (result != 0)
    {
    //    return 2;
    }
    //i2c_stop();        //stop write cycle
    i2c_readstart();    //start read cycle
    result = i2c_send(0x03);    //send read address
    if (result != 0)
    {
    //    return 3;
    }
    readval = i2c_rx();        //read one byte
    send_ack();
    //send_nak();
    i2c_stop();
    //return 0;
} 

//Parses the bits received from SM72442 
//to allow for one 16bit word for each data (voltages and current) sensed
void newouts(unsigned char num, unsigned char wide){
    unsigned char a, k;
    unsigned char r=0;
    unsigned char temp1 = 0, temp2 = 0;
    unsigned char tencount = 0;
    for(k=1;k<8;k++){
    outval[r] = 0;
        if (tencount==0){
            temp1 = readval[k];
        }else{
            temp1 = readval[k]>>tencount;
        }
            tencount += 2;
            temp2 = readval[k+1]<<(8-tencount);
            temp2 = temp2>>(8-tencount);
            outval[r] = (unsigned char) temp2;
            outval[r] = outval[r]<<(10-tencount);
            outval[r] |= (unsigned char) temp1;
            outval[r] = outval[r]&0x3FF; //Kill upper values
            
            r++;
        if (tencount == 8){
            tencount = 0;
            k++;
        }
    }
}

void bp(void){
    char bp = 0;
}
//get the sensed value from the SM72442 via I2C: send appropriate read command and
//receive the appropriate data contained in the SM72442
void get_i2c_data(){
	char result = 0;
    unsigned char i = 0;
    //drop_scl;
    //drop_sda();
    i2c_stop();
        i2c_start();    //start a write cycle (just to set the address)
        
        result = i2c_send(0x02);//send write address 0000001   0
        //vtest();
        result = i2c_send(0xE1);//address/command for read
        //vtest();
        i2c_readstart();
        //vtest();
        result = i2c_send(0x03);    //send read address 0000001   1
        //result = i2c_send(0x07);
        for(i=0;i<8;i++){
            //    vtest();
                readval[i] = i2c_rx();        //read one byte                
            //    vtest();
            if (i<7){
                send_ack();
            }else{
            //    readval[i] = i2c_rxlast();
                send_nak();
               // delay();
                i2c_stop();
               // delay();
                newouts(4, 10);
                bp();
            }
        }
}



char start_i2c_com()
{	char a;
	
	a=portc&SCL_PORT_MASK;
	if(a==0)
	{
			//if SCL held low
			return 1;
	}
	
	trisc=trisc&~SDA_PORT_MASK; //bring SDA low to issue start bit
	return 0;
}
	


//send stop bit (faster function)
char stop_i2c_com_newfunc()
{
	char a;
	trisc=trisc&~SCL_PORT_MASK; //force SCL low
	asm{
		nop
		nop
		nop
		nop
		}
	

	trisc=trisc&~SDA_PORT_MASK; //make sure SDA is low
	asm{
		nop
		nop
		nop
		nop
		}
	trisc=trisc|SCL_PORT_MASK; //allow SCL high
	asm{
		nop
		nop
		nop
		nop
		}
	a=portc&SCL_PORT_MASK;	
	while(a==0)
	{
	
		a=portc&SCL_PORT_MASK; //wait until SCL is left back high
			
	}
	tmr2=0;  //should give 50us time delay
	pir1=pir1&~00000010b;
	a=pir1&00000010b;
	while(a==0)
	{a=pir1&00000010b;}
	trisc=trisc|SDA_PORT_MASK; //bring SDA high to issue stop bit
	return 0;
}







char send_i2c_newfunc(char byte)
{
	char i=0,x,a;

	

		
	for(i=0;i<8;i++)
	{
		
		a=portc&SCL_PORT_MASK;
		if(a==0)
		{
			//if SCL held low
			
			while(a==0)
			{
				a=portc&SCL_PORT_MASK;
			}
		}
		trisc=trisc&~SCL_PORT_MASK; //bring the clock low
		
		//insert time delay here
		asm{
		nop
		nop
		}

		a=byte&0x80;
		if(a==0)
		{
			//set SDA=0;
			trisc=trisc&~SDA_PORT_MASK; //bring the data line (SDA) low
		}
		else
		{
			//set SDA=1;
			trisc=trisc|SDA_PORT_MASK; //bring SDA high
		}
		//insert time delay here
		asm{
		nop
		nop
		}
		trisc=trisc|SCL_PORT_MASK; //bring SCL back high
		a=portc&SCL_PORT_MASK;
		if(a==0)
		{
			//SCL kept low by slave;
		}
		asm{
		nop
		nop
		}

		//insert time delay here
		byte=byte<<1;
		
	}
	
	
	trisc=trisc&~SCL_PORT_MASK; //bring the  clock line (SCL) low for slave acknowledgment
		asm{
		nop
		nop
		}

	//insert time delay here;
	trisc=trisc|SDA_PORT_MASK; //bring SDA high to listen for slave's acknowledgment
		asm{
		nop
		nop
		}
	a=portc&SDA_PORT_MASK;
	if(a==0)
	{
			//SDA kept low by slave: acknowledgment;
			trisc=trisc|SCL_PORT_MASK; //bring the  clock line (SCL) back high
			asm{
			nop
			nop
			}
			return 1;
			
	}
	else
	{
			//no acknowledgment from slave;
			trisc=trisc|SCL_PORT_MASK; //bring the  clock line (SCL) back high
			asm{
			nop
			nop
			}
			return 0;
	}
		asm{
		nop
		nop
		}

	
}	

	
char send_i2c_command(char number) //"number" is the amount of character to send from the buffer
{

	char a,i;
	char no_ack_flag=0;
	a=1;
	
	
	asm{
		bcf _portc, 4
		nop
		nop
		nop
		bcf	_portc, 3
		}
	while(a!=0)
	{
		a=start_i2c_com();
	}
	for(i=0;i<number;i++)
	{
		a=send_i2c_newfunc(i2c_buffer[i]);
		if(a==0)
		{
			no_ack_flag++;
			i=i-1;
		}
		else
		{
			no_ack_flag=0;
		}
		if(no_ack_flag==3)
		{
			return 1;
		}
	}
	stop_i2c_com_newfunc();
	return 0;
}

//This function sets the output voltage limit by sending the proper I2C command
// 1- Set the send I2C buffer bits
// 2- call the send_i2c_command specifying hoe many bytes from the buffer to send.
// Check SMbus protocol and SM72442 datasheet for mor info.
char set_Voutmax(int voutmax)
{

	sspcon=0x3B;
	i2c_buffer[0]=0x02; //address of the LM25092 is 0x01 (7bits address + 0 for a write operation)
	i2c_buffer[1]=0xE3; //0XE3 to write to register 3
	i2c_buffer[2]=0x06; //writing 6 bytes of data to target
	i2c_buffer[3]=0x00; //byte 1
	i2c_buffer[4]=0x80; 
	i2c_buffer[5]=0xF4;
	i2c_buffer[6]=0xFF;
	i2c_buffer[7]=0xFF;
	i2c_buffer[8]=0x00; //byte 6

	unsigned char a;
	unsigned int b;
	i2c_buffer[6]=0xFF;
	i2c_buffer[7]=0xFF;
	a=voutmax&0x0F; //keep 4 LSBs
	a=a<<4; //LSBs become MSB for register bits 16-23
	i2c_buffer[5]=i2c_buffer[5]|a;
	a=a|0x0F;
	i2c_buffer[5]=i2c_buffer[5]&a;
	b=voutmax>>4;
	a=(char)(b);
	i2c_buffer[6]=i2c_buffer[6]|a;
	a=a|0xC0;
	i2c_buffer[6]=i2c_buffer[6]&a; 
	i2c_buffer[8]=0x43;
	a=send_i2c_command(9); //after buffer is ready to be sent, call the function that will transmit the message
}