*****************************************************************************
* (C) Copyright 2011 Texas Instruments Incorporated. All rights reserved.
*****************************************************************************
** This model is designed as an aid for customers of Texas Instruments.
** TI and its licensors and suppliers makeno warranties, either expressed
** or implied, with respect to thismodel, including the warranties of
** merchantability or fitness fora particular purpose. The model is
** provided solely on an "as is" basis. The entirerisk as to its quality
** and performance is with the customer.
*****************************************************************************
*
* Released by: Analog eLab Design Center, Texas Instruments Inc.
* Part:        SN75DP130
*              
* Date:        2011-03-15
* Model Type:  HSPICE
* Simulator:   HSPICE_A-2008.03-SP1  (Windows)
* 
*
*****************************************************************************
* Model version 1.0:
*****************************************************************************
*subckt DP130_TOP_model out2p in0p in0n in1n in1p in2p in2n in3p in3n 
*+ en_vregd_dnbond en_vrega_dnbond vddd addr_eq scl_ctl sda_ctl cad_src
*+ hpd_src cad_snk hpd_snk out3p out3n out2n gnd vdda out1n out1p out0n
*+ out0p v3p3 sda_ddc scl_ddc aux_srcp aux_srcn aux_snkp aux_snkn enable reset
******** circuit definition
*.ends
****************************************************************************
* The current setup simulation takes almost 20 minutes to complete.

* General information about this model:

* Schematic based. 
* Does not have package parasitics. 
* Squelch exit timing simplified.
* All logic subchips are taken out; no link training possible; HPD/CAD timing altered.
* TX in TMDS mode only offers a single VOD, no PE. Some more VOD/PE settings
* allowed in actual design.
* AUX switch driving circuits simplified.

* Following parameters to setup high-speed input differential data:

* Vid                      Input VID
* delay                   		 may set ~10nS
* Vid                      Input VID
* ER                       Edge rate
* UI                       Bit period

* DP130SS vs DS:

* For SS: Do not connect EN_VREGA(D)_DNBND pins (internal schematic pins)
* For DS: connect EN_VREGA(D)_DNBND pins to ground


* Following parameters to setup DP130:

* enb_sq                   Enable Squelch function
* enb_aux                  Enable AUX switch path
* en_lane0,1,2,3           Enables lanes
* eq2,1,0                  RX Equalization: 000=0dB, 111:18dB at 2.7Ghz
* vod1,0                   TX VOD in DP mode; 00 L0, 01 L1, 10 L2 11 L3
* pe1,0                    TX Pre-emphasis in DP mode; 00 L0, 01 L1, 10 L2 11 L3
*                          note certain PE/VOD combinations not allowed
* dr1,0                    Datarate in DP mode; 00 1.6G, 01 2.7G, 10 5.4Gbps

.PARAM vcc=3.3
.PARAM vdd=1.05
.PARAM delay=10e-9
.PARAM enb_aux=1
.PARAM dr1=0
.PARAM dr0=0
.PARAM pe0=0
.PARAM vod1=0
.PARAM enb_sq=1
.PARAM vod0=0
.PARAM pe1=0
.PARAM en_lane0=1
.PARAM eq2=0
.PARAM en_lane3=0
.PARAM en_lane2=0
.PARAM en_lane1=0
.PARAM eq0=0
.PARAM eq1=0
.PARAM ui=185e-12
.PARAM er=50e-12
.PARAM vid=300e-3

.PROBE TRAN
+    V(out0)
+    V(outn3)
+    V(outp3)
+    V(outn2)
+    V(outp2)
+    V(outn1)
+    V(outp1)
+    V(outn0)
+    V(outp0)
+    V(in0n)
+    V(in0p)
.TRAN 1e-9 40e-9 START=0.0

.OP

.TEMP 25
.OPTION ACCT ACCURATE NOPAGE OPTS POST SCALE=1e-6
.OPTION METHOD=GEAR

.INCLUDE "nominal_process_windows.lib"
.INCLUDE "DP130_subckts_windows.sp"

** Test Bench Description for the DP130 model
** 
xi0  inn_0 inp_0 _net0 source_for_AC_coupling_PRBS_50ohm
xDUT net29 in0p  in0n net8 net9 net7 net6 net17 net16 gnd gnd vddd _net0 n33 n33 cad_src hpd_src _net0 n33 net27 net26 net28 gnd vdda net30 net31 out0n_ out0p_ v3p3 n33 n33 auxsrcap auxsrcan net96 net42 n33 n1 DP130_TOP_model
*
c10  inp_0   0     100e-15
c12  inp_0   in0p  100e-9
*
c11  inn_0   in0n  100e-9
c14  inn_0   0     100e-15
*
v37  v3p3    0      DC=3.3 AC 1
v0   gnd     0      DC=0
v3   net105  0      DC=1.5
v10  net97   0      DC=1.5
v14  vddd    0      DC=1.05
v4   net107  0      DC=1.5
v5   net117  0      DC=1.5
v6   net71   0      DC=1.5
v13  vdda    0      DC=1.05
v11  n33     v3p3   DC=0
v9  _net0    gnd    DC=0
v7   n1      vddd   DC=0
e0   out0    0 VCVS outp0 outn0 1
e1   auxsnk  0 VCVS net75 net89 1
r1   outn0   net101 50
r52  0       auxsnk 10e3
r18  net75   net90  50
r9   v3p3    net96  1e6
r8   net90   net89  50
r7   net42   0      1e6
r6   v3p3    net42  100e3
r5   net96   0      100e3
r20  net90   net97  10e3
r0   outp0   net101 50
r2   net101  net105 10e3
r3   net111  net107 10e3
r4   outp1   net111 50
r10  outn1   net111 50
r11  outn2   net113 50
r12  outp2   net113 50
r13  net113  net117 10e3
r14  net123  net71 10e3
r15  outp3   net123 50
r16  outn3   net123 50
c8   out0p_  outp0 100e-9
c13  net90   0     10e-12
c3   net75   net42 75e-9
c2   net89   net96 75e-9
c7   out0n_  outn0 100e-9
c0   net31   outp1 100e-9
c1   net30   outn1 100e-9
c4   net28   outn2 100e-9
c5   net29   outp2 100e-9
c6   net27   outp3 100e-9
c9   net26   outn3 100e-9
c19  vddd    0     1e-6
.END
