*GTLP817(DIE C) HSPICE MODEL
****************************************************************************
***************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized      * 
*          reproduction and/or distribution is strictly prohibited.       *
*                                                                         * 
*          This product is protected under copyright law.                 *  
*          Created 1999, (C) Copyright 1999, Texas Instruments Inc.,      *  
*          All Rights Reserved                                            *  
*                                                                         *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE             *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE      *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR          *
*          IMPLIED.  TI assumes no liability for:                         *
*          1) the accuracy of the SPICE models provided to your           *
*             company;                                                    *
*          2) the proper functioning of these SPICE models in your        *
*             design or for any resulting applications; or                *
*          3) infringement of patents, copyrights or intellectual         *
*             property rights resulting from your use of these            *
*             SPICE models.                                               *
*                                                                         *
*          TI provides SPICE Models as a service to our customers.        *
*          You and your company shall not distribute, sell or give        *
*          these models to anyone else without prior written              *
*          permission from TI.                                            *
*                                                                         *
*          TI reserves the right to make changes to our products or 	  *
*          to discontinue any semiconductor product or service            *
*          without notice, and advises our customers to obtain the 	  *
*          latest version of relevant information to verify, before       *
*          placing orders, that the information being relied on is 	  *
*          current.                                                       *
*                                                                         *
*          Please be aware that your receipt and use of the SPICE 	  *
*          information provided shall serve as acceptance of these 	  *
*          terms and conditions.  If you do not accept these terms,	  *
*          you should return or destroy the SPICE models and any          *
*          other accompanying information immediately.			  *
***************************************************************************
***************************************************************************
***************************************************************************

* SPICE block diagram
*                                                      
*                   ----
*                   |   \
*               ____|    \o____ Node outina
*              |    |    /                              VCC
*              |    |   /                               /|\
*              |    ----                                 |
*              |                                         |
*              |                                      Node x_vcc
*  Node x_a  --*      Node tria                       Node x_gnd
*              |        |                                |
*              |        o                                |
*              |       ----                             ---
*              |      /   |                              -
*              |____ /    |____ Node inaout
*                    \    |
*                     \   |
*                      ----
*
*               GTLP817B_APORT (LVTTL)
**************************************************************
*
*
*                   Node vref
*                     |
*                     |
*                   ----
*                   |   \
*               ____|    \o____ Node outinb
*              |    |    /                              VCC
*              |    |   /                               /|\
*              |    ----                                 |
*              |                                         |
*              |                                      Node x_vcc
*  Node x_b  --*      Node trib                       Node x_gnd
*              |        |                                |
*              |        o                                |
*              |       ----                             ---
*              |      /   |                              -
*              |____o/    |____ Node inbout
*                    \    |
*                     \   |
*                      ----
*                        |
*                        |
*                     Node verc       
*
*


*   Please refer to the 'READ.ME' file for general instructions for use.
*

************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
*************************************************************************
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
***********************************************************************
	.OPTIONS search='./'


***ENCRYPTED DEVICE NETLIST*****

X_DEVICE_SELECTOR 0 GTLP817INC


*PROCESS MODELS
*ASL3C5N37INC  ENCRYPTED  NOMINAL PROCESS MODEL
*ASL3C5S37INC  ENCRYPTED  STRONG PROCESS MODEL
*ASL3C5W37INC  ENCRYPTED  WEAK PROCESS MODEL

****PLEASE INCLUDE ONE OF THE FOLLOWING PROCESS**

 X_PROCESS_MODELS  0   ASL3C5N37INC
*X_PROCESS_MODELS  0   ASL3C5S37INC
*X_PROCESS_MODELS  0   ASL3C5W37INC

*PKG MODEL****

.LIB  'PKGS.LIB'  TVSOP24




***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
	
xgtlp817   AI  BI  AO1  BO1 REF NOEAB NOEBA ERC  CCGND CVCC CGND gtlp817
 


*****SUBCKT for pkg connection*****
.subckt gtlp817 
+p_AI
+p_BI
+p_AO1  
+p_BO1
+p_REF
+p_NOEAB  
+p_NOEBA  
+p_ERC  
+p_CCGND  
+p_CVCC
+p_CGND  

X_PIN01  p_AI		s_AI  		TVSOP24_01
X_PIN02	 p_AO1		s_AO1		TVSOP24_02
X_PIN03	 p_CGND	        s_CGND		TVSOP24_03
X_PIN05	 p_CVCC	        s_CVCC		TVSOP24_05
X_PIN14	 p_NOEBA 	s_NOEBA		TVSOP24_14
X_PIN15  p_BI		s_BI 		TVSOP24_15
X_PIN16  p_CCGND	s_CCGND		TVSOP24_16
X_PIN18  p_ERC 		s_ERC		TVSOP24_18
X_PIN20  p_REF		s_REF 		TVSOP24_20
X_PIN22  p_BO1	        s_BO1	        TVSOP24_22
X_PIN23  p_NOEAB  	s_NOEAB 	TVSOP24_23



xgtlp817_bit

+s_AI
+s_BI
+s_AO1  
+s_BO1
+s_REF
+s_NOEAB  
+s_NOEBA  
+s_ERC  
+s_CCGND  
+s_CVCC
+s_CGND  

+gtlp817_bit

.ENDS gtlp817


******************
**PARAMETER
*******************
.temp 40



**********************
**THE FOLLOWING IS A TEST SIMULATION FOR A  DATA TO B BUS*****
***********************



VNOEBA	 	NOEBA 	 0 	dc 3.3		
VERC		ERC	 0 	dc 3.3
VNOEAB  	NOEAB 	 0	dc 0v

VREF   		REF 	 0 	dc 1.0v
 
***********************************************************************
******Supply Voltages
***********************************************************************
Vcvcc	CVCC  		0  dc 3.3v  
Vcgnd	CGND		0  dc 0v
Vccgnd  CCGND           0  dc 0v
***********************************************************************
******Termination Voltages
***********************************************************************

V_tt        tt   0  dc 1.5	

************************************************************************
***********************************************************************
.TRAN         0.05NS 30NS
*
**** TRANSIENT ANALYSES <-------
** Propagation test (LH/HL)

v_a         AI    0   PULSE (0  3.3   5NS  1NS  1NS  10NS  20NS)

******LOAD CKT FOR B OUTPUT***
******

R_B_load  BO1  tt  25
C_B_load  BO1  0  30pF


****UNUSED  PORT****
 
V_BO  AO1  0  dc 0v 
V_BI  BI  0   dc 3.3v



.END


