************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 2003, (C) Copyright 2003, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
*
* SLL APPLICATIONS
* DATE : NOV, 2003 
*NOTE:
*This is the user's file.Refer to the read.me file before you proceed.
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
*
    .OPTIONS search='./'
***********************************************************************
* DEVICE NETLIST
***********************************************************************
X_DEVICE_SELECTOR  0 CBTLV16210INC

***********************************************************************
*ENCRYPTED PROCESS MODEL. PLEASE CHOOSE ONLY ONE 
*PROCESS MODEL FILE (NOMINAL, STRONG or WEAK)
***********************************************************************

        X_PROCESS_SELECTOR 0 ASL3C_BSIM3_NINC   $NOMINAL LEVEL 49 PROCESS MODEL 
*       X_PROCESS_SELECTOR 0 ASL3C_BSIM3_SINC   $STRONG  LEVEL 49 PROCESS MODEL
*       X_PROCESS_SELECTOR 0 ASL3C_BSIM3_WINC   $WEAK    LEVEL 49 PROCESS MODEL

*PACKAGE FILE. PLEASE CHOOSE ONLY ONE PACKAGE FILE and change the 
*corresponding subcircuit connection. For example change TSSOP48_01 to
* TVSOP56_01
***********************************************************************

.INCLUDE  'TSSOP48.PKG'
*.INCLUDE 'TVSOP48.PKG'
*.INCLUDE 'SSOP48.PKG'


***********************************************************************
* Refer to the data sheet for node description.
***********************************************************************
******Top level Subcircuit call (user's nodes)
***********************************************************************

xCBTLV16210 
+x_1noe
+x_2noe
+x_1A1
+x_1B1
+x_2A1
+x_2B1
+x_CGND
+x_CVCC

+CBTLV16210

***********************************************************************
******Supply Voltages
***********************************************************************
v_vcc     x_CVCC      0     DC     3.3
v_gnd     x_CGND      0     DC     0

***********************************************************************
******Subcircuit for package connection
***********************************************************************

.subckt CBTLV16210 
+p_1noe
+p_2noe
+p_1A1
+p_1B1
+p_2A1
+p_2B1
+p_CGND
+p_CVCC

X_PIN_2		p_1a1		s_1a1	TSSOP48_02
X_PIN_13	p_2a1		s_2a1	TSSOP48_13
X_PIN_8		p_CGND		CGND	TSSOP48_08
X_PIN_17	p_CVCC		CVCC	TSSOP48_17
X_PIN_35	p_2B1		s_2b1	TSSOP48_35
X_PIN_46 	p_1B1		s_1b1	TSSOP48_46
X_PIN_47 	p_2noe		s_2noe	TSSOP48_47
X_PIN_48 	p_1noe		s_1noe	TSSOP48_48

X_CBTLV16210_die s_1noe s_2noe s_1a1 s_1b1 s_2a1 s_2b1 CVCC CGND cbtlv16210__bit

 
.ENDS CBTLV16210 

***********************************************************************

.TRAN         1NS 200NS

** 1A1--> 1B1 DATA TRANSFER

R_LOAD_1B1   x_1B1    0   500
C_LOAD_1B1   x_1B1    0   50pF

R_LOAD_2B1   x_2B1    0   500
C_LOAD_2B1   x_2B1    0   50pF




V_1A1      	x_1A1 0 PULSE (0 3.3  5NS  1NS  1NS  50ns  100NS)

V_2A1      	x_2A1 0 PULSE (3.3 0 10NS  1NS  1NS  25NS  50NS)




**1A1-->1B1 Data Transfer**

V_1noe 		x_1noe 	   0 DC 0
V_2noe 		x_2noe 	   0 DC 0

 
.PRINT TRAN V(x_1A1) V(x_1A2) V(x_1B1) V(x_2B1) 

.alter 
V_1noe 		x_1noe 	   0 DC 3.3
V_2noe 		x_2noe 	   0 DC 3.3


.END
                                         




