//*****************************************************************************
//  MSP430G2131 / DRV8816 Customer EVM Demo
//
//  Description: Using DRV8839 Customer EVM PWM_SEL_EN_1,PWM_SEL_EN_2 to control
//  the output of DRV8839 , PWM_SEL_EN_1 low selects disable output1 of DRV8839,
//  PWM_SEL_EN_1 high selects enable of DRV8839, the same as PWM_SEL_EN_2.

//  Timer_A CCR0 drives in upmode, 6-bit PWM.PWM DutyCycle is measured using
//  poti on ADC10_A0 and ADC10_A7. The pwm dutycycle of output1 is adjusted to
//  the input of ADC10_A0,the pwm dutycycle of output2 is adjusted to the input
//  of ADC10_A7.

//  And the LED is lighted up when power on
//  PWM frequency = 10.2Khz

//******************************************************************************

#include "msp430g2131.h"

#define LED         BIT1                 // P1.1
#define IN_1_PWM    BIT2                 // P1.2
#define IN_2_PWM    BIT6                 // P2.6
#define ADC_VREF    BIT4                 // P1.4

#define PWM_SEL_EN_1  BIT7               //P2.7
#define PWM_SEL_EN_2  BIT3               // P1.3

#define EN1         BIT5                 // P1.5
#define EN2         BIT6                 // P1.6



unsigned int LEDcounter = 0;            // Countdown timer for LED toggle
unsigned int DutyCycle,DutyCycle1,DutyCycle2;  // 6-bit PWM duty cycle
unsigned int timer_interrpt = 0;
unsigned int ADC_count , sample_flag ;

int main(void)
{
  WDTCTL = WDTPW + WDTHOLD;               // Stop watchdog timer
//  BCSCTL1 = CALBC1_1MHZ;                // Set DCO to 1MHz
//  DCOCTL = CALDCO_1MHZ;
  BCSCTL1 = RSEL0+RSEL1+RSEL2+RSEL3;      // Set DCO to fastest
  DCOCTL =DCO0+DCO1+DCO2;
  P1OUT = 0x00;                          // P1.x Reset
  P1DIR = IN_1_PWM + LED + EN1 + EN2;    // IN_1 and LED outputs
  P2OUT = 0x00;                          // P2.x reset
  P1SEL = 0x00;                         // Enable IN_1 PWM
  P2SEL = 0x00;                          // P2.x no options
  P2DIR = IN_2_PWM;                      // IN_2 output

  CCR0 = 60;                             // 6-bit PWM period

  TACTL = TASSEL_2 + MC_1;              // SCLK source, up mode
  CCTL0=CCIE;                           //Enable Timer A interrupt
  _EINT();                              //Enable global interrupt

// ADC reference voltage on at 2.5V, and output pin with Vref+
  ADC10CTL0 = SREF_1 + ADC10SHT_2 + REFON + + REF2_5V + REFOUT + ADC10ON;


  P1OUT |=  LED;                        //Light the LED on



  while (1){

    if( PWM_SEL_EN_2 & P1IN)
      P1OUT |= EN2;                     //If P1.3 is high, then enable the OUTPUT 2 of DRV8839
    else
      P1OUT &= ~EN2;                    //If P1.3 is low, then disable the OUTPUT 2 of DRV8839
    if( PWM_SEL_EN_1 & P2IN)
      P1OUT |= EN1;                     //If P2.7 is high, then enable the OUTPUT 1 of DRV8839
    else
      P1OUT &= ~EN1;                    //If P2.7 is low, then disable the OUTPUT 1 of DRV8839

    if(sample_flag)
    {
      sample_flag=0;
      ADC10CTL0 &= ~ENC;
      ADC10CTL1 = INCH_0  ;                   // ADC option select
      ADC10CTL0 |= ENC + ADC10SC;             // Sampling and conversion start
      while (!(ADC10IFG & ADC10CTL0));        // Wait for conversion complete
      ADC10CTL0 &= ~ADC10IFG;                 // Clear converstion flag
      DutyCycle1 = ADC10MEM >>5;              // Mask upper 5-bits

      ADC10CTL0 &= ~ENC;
      ADC10CTL1=0;
      ADC10CTL1 = INCH_7 ;                   // ADC option select
      ADC10CTL0 |= ENC + ADC10SC;            // Sampling and conversion start
      while (!(ADC10IFG & ADC10CTL0));       // Wait for conversion complete
      ADC10CTL0 &= ~ADC10IFG;                // Clear converstion flag
      DutyCycle2 = ADC10MEM >>5;

    }

  }
}

#pragma vector=TIMERA0_VECTOR
__interrupt void TIMERA1_INTERRPT()
{


//  TACCTL0 &= ~CCIFG;
  if(DutyCycle1 >= timer_interrpt)           //Adjusted the PWM duty to the ADC input
    P1OUT |= IN_1_PWM;
  else
    P1OUT &= ~IN_1_PWM;

  if(DutyCycle2 >= timer_interrpt)           //Adjusted the PWM duty to the ADC input
    P2OUT |= IN_2_PWM;
  else
    P2OUT &= ~IN_2_PWM;

  timer_interrpt++;
  if(timer_interrpt > 31)
    timer_interrpt = 0;
  ADC_count++;
  if(ADC_count>100)                           //ADC sample interval
  {
    sample_flag=1;
    ADC_count=0;
  }
}
