/*
 *  Copyright 2003 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 *  
 */
/* "@(#) DDK 1.11.00.00 11-04-03 (ddk-b13)" */
#include <std.h>
#include <csl_cache.h>
#include <fvid.h>
#include <csl_dat.h>   
#include "colorbarRGB.h"   


/* static function declaration */
static void generateColorBarRGB(Uint16* buf, Int lineSize);

#define WHITE        0xBDF7
#define YELLOW       0xC5E0
#define CYAN         0x05F7
#define GREEN        0x05E0
#define MAGENTA      0xB818
#define RED          0xB800
#define BLUE         0x0017
#define BLACK        0x0000

static Uint16 imgLineRGB[1024 * 3];


/*
 * ======== fillFrmBufRGB ========
 * This function fill a frame with color bar of RGB565 format.
 */

void FillFrmBufRGB(FVID_RawPFrame* frame, Int lineSz, Int numLines, Int offset)
{
    Int i;
    Int id;
    static Int init = 0; 
    if(!init) {
        generateColorBarRGB(imgLineRGB, lineSz);
        CACHE_clean(CACHE_L2ALL, NULL, NULL);
        init = 1;
    }    
    for(i = 0; i < numLines; i ++) {        
        id = DAT_copy(imgLineRGB + offset * 8, frame->buf + (lineSz << 1) * i, 
            (lineSz << 1));
    }
    DAT_wait(id);
}          

/*
 * ======== generateColorBarRGB ========
 * This function generates a line of color bar with RGB565 format.
 */

static void generateColorBarRGB(Uint16* buf, Int lineSize)
{
    Int i;   
    Int fillSize = lineSize >> 3;
    Int k;
    
    for(k = 0; k < 3; k ++) {
        for(i = 0; i < fillSize; i ++) {
            buf[i] = WHITE;
            buf[fillSize * 1 + i] = YELLOW;
            buf[fillSize * 2 + i] = CYAN;
            buf[fillSize * 3 + i] = GREEN;     
            buf[fillSize * 4 + i] = MAGENTA;     
            buf[fillSize * 5 + i] = RED;     
            buf[fillSize * 6 + i] = BLUE;     
            buf[fillSize * 7 + i] = BLACK;     

        }    
        buf  += lineSize;
    }

}
