******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for SN74LVCE161284
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2005, (C) COPYRIGHT 2005, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'sn74lvce161284.inc'
X__SN74LVCE161284 HD A9 A10 A11 A12 A13 VCC A1 A2 GND A3 A4 A5 A6 GND A7 A8
+ VCC PLIN A14 A15 A16 A17 HLOUT HLIN C17 C16 C15 C14 PLOUT VCC5 B8 B7 GND B6
+ B5 B4 B3 GND B2 B1 VCC5 Y13 Y12 Y11 Y10 Y9 DIR SN74LVCE161284
*** PULSE PARAMETERS ***
.param PFREQ1=10MEG $ 1st pulse (clk) frequency
.param PRFT19=2ns $ rise/fall time
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage
.param PVT=1.4 $ input threshold voltage
.param PMAX=30ns $ max SPICE delay time
.param PRFT='(PRFT19/0.8)' $ convert rise/fall time to 100$
.param PPD1='(1/PFREQ1)' $ period of 1st pulse
.param PPW1='((PPD1 - (PRFT*2))/2)' $ pulse width of 1st pulse

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+PMAX+20n' $
.TRAN 0.05n 'PSTOP' 'PSTART' 0.05n
.PRINT TRAN v(DATA)

* SET CONTROL INPUTS TO ENABLE OUTPUT
VC0 DIR 0 DC 'PVCC'
VC1 HD 0 DC 'PVCC'


*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VI0 A1 0 pulse 'PVIN' 0 'PDELAY1' 'PRFT' 'PRFT' 'PPW1' 'PPD1'


* CHANGE TO THE OUTPUT NODE
VDATA B1 DATA DC 0
RLOAD DATA VCC 500

* VOLTAGE SUPPLIES
V5 VCC5 VCC 0

.param PVCC=3.3
.param PGND=0v
VVCC VCC 0 'PVCC'
VGND GND 0 'PGND'

.TEMP 40

* RESISTORS TO PREVENT DANGLING NODES
* R1G_1 HD 0 1G
R1G_2 A9 0 1G
R1G_3 A10 0 1G
R1G_4 A11 0 1G
R1G_5 A12 0 1G
R1G_6 A13 0 1G
R1G_7 VCC 0 1G
* R1G_8 A1 0 1G
R1G_9 A2 0 1G
* R1G_10 GND 0 1G
R1G_11 A3 0 1G
R1G_12 A4 0 1G
R1G_13 A5 0 1G
R1G_14 A6 0 1G
* R1G_15 GND 0 1G
R1G_16 A7 0 1G
R1G_17 A8 0 1G
R1G_18 VCC 0 1G
R1G_19 PLIN 0 1G
R1G_20 A14 0 1G
R1G_21 A15 0 1G
R1G_22 A16 0 1G
R1G_23 A17 0 1G
R1G_24 HLOUT 0 1G
R1G_25 HLIN 0 1G
R1G_26 C17 0 1G
R1G_27 C16 0 1G
R1G_28 C15 0 1G
R1G_29 C14 0 1G
R1G_30 PLOUT 0 1G
* R1G_31 VCC5 0 1G
R1G_32 B8 0 1G
R1G_33 B7 0 1G
* R1G_34 GND 0 1G
R1G_35 B6 0 1G
R1G_36 B5 0 1G
R1G_37 B4 0 1G
R1G_38 B3 0 1G
* R1G_39 GND 0 1G
R1G_40 B2 0 1G
* R1G_41 B1 0 1G
* R1G_42 VCC5 0 1G
R1G_43 Y13 0 1G
R1G_44 Y12 0 1G
R1G_45 Y11 0 1G
R1G_46 Y10 0 1G
R1G_47 Y9 0 1G
* R1G_48 DIR 0 1G

.END
