************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 2003, (C) Copyright 2003, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
*
* SLL APPLICATIONS
* DATE :JULY 2003
*NOTE:
*This is the user's file.Refer to the read.me file before you proceed.
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-12     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-12
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
*    .OPTIONS GSHUNT=1E-10   
******IF THERE IS TIMESTEP CCONVERGENCE PROBLEM TRY TO CHANGE GMIN AND GMINDC OR**GSHUNT***


***********************************************************************
*
*   NOTE:
*   The following files must be present to use this SPICE model:
*      AHC16244INC.INC       (netlist)
*      EPIC1SL49NINC.INC        (Nominal process models)
*      EPIC1SL49SINC.INC        (Strong process models) 	
*      EPIC1SL49WINC.INC        (Weak    process models)
*      PKGS.LIB                 (PKG LIBRARY FILE)
*	SSOP48.PKG
*	TSSOP48.PKG
*	TVSOP48.PKG

*      (Choose only one package model and one process model)
*      .
*      .
*      .
***********************************************************************
	.OPTIONS search='./'

X_DEVICE_SELECTOR  0 LVCZ161284AINC

** NOMINAL PROCESS MODEL
X_PROCESS_SELECTOR 0  EPIC1SL49NINC      

** STRONG PROCESS MODEL

*X_PROCESS_SELECTOR 0 EPIC1SL49SINC 

** WEAK PROCESS MODEL 

*X_PROCESS_SELECTOR 0  EPIC1SL49WINC

.INCLUDE 'TSSOP48.PKG'




***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
x_lvcz161284a

+HD 
+A9 
+A10 
+A11 
+A12 
+A13 
+VCC7
+A1 
+A2 
+GND10 
+A3 
+A4 
+A5 
+A6 
+GND15 
+A7 
+A8 
+VCC18
+PERI_IN 
+A14 
+A15 
+A16 
+A17 
+HOST_OUT
+HOST_IN
+C17
+C16
+C15
+C14
+PERI_OUT 
+VCC_CABLE31
+B8
+B7
+GND34
+B6
+B5
+B4
+B3
+GND39
+B2
+B1
+VCC_CABLE42
+Y13
+Y12
+Y11
+Y10
+Y9
+DIR 

+lvcz161284a


***********************************************************************
******Supply Voltages
***********************************************************************
VGND          GND   0   DC 0 
VVCC5         VCC5  GND DC 5  

VGND10		GND10	    GND  DC 0v
VGND15		GND15	    GND  dc 0v
VGND34		GND34	    GND  dc 0v
VGND39		GND39	    GND  dc 0v
VVCC7           VCC7        GND dc 3.3
VVCC18          VCC18       GND dc 3.3
VVCC_CABLE31    VCC_CABLE31 GND  dc 5V     
VVCC_CABLE42    VCC_CABLE42 GND  dc 5V 






**DUMMY RESISTORS**
R_HD HD GND 100e6
R_A9 A9 GND 100e6
R_A10 A10 GND 100e6
R_A11 A11 GND 100e6
R_A12 A12 GND 100e6
R_A13 A13  GND 100e6
R_VCC7 VCC7 GND 100e6
R_A1  A1  0 100e6
R_A2  A2  0 100e6
R_GND10 GND10  0 100e6
R_A3  A3  0 100e6
R_A4  A4  0 100e6
R_A5  A5  0 100e6
R_A6  A6  0 100e6
R_GND15  GND15  0 100e6
R_A7  A7  0 100e6
R_A8  A8  0 100e6
R_VCC18 VCC18  0 100e6
R_PERI_IN PERI_IN  0 100e6
R_A14 A14  0 100e6
R_A15 A15  0 100e6
R_A16 A16  0 100e6
R_A17 A17  0 100e6
R_HOST_OUT HOST_OUT 0 100e6
R_HOST_IN HOST_IN 0 100e6
R_C17 C17 0 100e6
R_C16 C16 0 100e6
R_C15 C15 0 100e6
R_C14 C14 0 100e6
R_PERI_OUT PERI_OUT 0 100e6
R_VCC_CABLE31  VCC_CABLE31 0 100e6
R_B8 B8 0 100e6
R_B7 B7 0 100e6
R_GND34 GND34 0 100e6
R_B6  B6 0 100e6
R_B5  B5 0 100e6
R_B4  B4 0 100e6
R_B3 B3 0 100e6
R_GND39 GND39 0 100e6
R_B2 B2 0 100e6
R_B1 B1 0 100e6
R_VCC_CABLE42 VCC_CABLE42 0 100e6
R_Y13 Y13 0 100e6
R_Y12 Y12 0 100e6
R_Y11 Y11 0 100e6
R_Y10 Y10 0 100e6
R_Y9  Y9 0 100e6
R_DIR  DIR 0 100e6





***********************************************************************
******Subcircuit for package connection
***********************************************************************

.SUBCKT lvcz161284a  
+HD 
+A9 
+A10 
+A11 
+A12 
+A13 
+VCC7
+A1 
+A2 
+GND10 
+A3 
+A4 
+A5 
+A6 
+GND15 
+A7 
+A8 
+VCC18
+PERI_IN 
+A14 
+A15 
+A16 
+A17 
+HOST_OUT
+HOST_IN
+C17
+C16
+C15
+C14
+PERI_OUT 
+VCC_CABLE31
+B8
+B7
+GND34
+B6
+B5
+B4
+B3
+GND39
+B2
+B1
+VCC_CABLE42
+Y13
+Y12
+Y11
+Y10
+Y9
+DIR 


X_PIN_01 	HD 	 P_HD    	TSSOP48_01 
X_PIN_02 	A9 	 P_A9    	TSSOP48_02
X_PIN_03 	A10 	 P_A10   	TSSOP48_03 
X_PIN_04 	A11 	 P_A11   	TSSOP48_04 
X_PIN_05 	A12 	 P_A12   	TSSOP48_05 
X_PIN_06 	A13 	 P_A13   	TSSOP48_06 
X_PIN_07 	VCC7 	 P_VCC7  	TSSOP48_07 
X_PIN_08 	A1 	 P_A1  		TSSOP48_08
X_PIN_09 	A2 	 P_A2  		TSSOP48_09
X_PIN_10 	GND10 	 CGND  		TSSOP48_10
X_PIN_11 	A3 	 P_A3  		TSSOP48_11
X_PIN_12 	A4	 P_A4  		TSSOP48_12
X_PIN_13 	A5 	 P_A5  		TSSOP48_13
X_PIN_14 	A6 	 P_A6  		TSSOP48_14
X_PIN_15 	GND15 	 CGND  		TSSOP48_15
X_PIN_16 	A7 	 P_A7  		TSSOP48_16
X_PIN_17 	A8 	 P_A8  		TSSOP48_17
X_PIN_18 	VCC18 	 CVCC  		TSSOP48_18
X_PIN_19	PERI_IN  P_PERI_IN 	TSSOP48_19
X_PIN_20 	A14 	 P_A14 		TSSOP48_20
X_PIN_21 	A15 	 P_15 		TSSOP48_21
X_PIN_22 	A16 	 P_A16  	TSSOP48_22
X_PIN_23 	A17 	 P_A17  	TSSOP48_23
X_PIN_24 	HOST_OUT P_HOST_OUT  	TSSOP48_24
X_PIN_25 	HOST_IN  P_HOST_IN   	TSSOP48_25
X_PIN_26 	C17 	 P_C17		TSSOP48_26
X_PIN_27 	C16 	 P_C16		TSSOP48_27
X_PIN_28 	C15 	 P_C15		TSSOP48_28
X_PIN_29 	C14 	 P_C14   	TSSOP48_29
X_PIN_30 	PERI_OUT P_PERI_OUT  	TSSOP48_30
X_PIN_31 	VCC_CABLE31 CVCC5  	TSSOP48_31
X_PIN_32 	B8      P_B8 		TSSOP48_32
X_PIN_33 	B7 	P_B7 		TSSOP48_33
X_PIN_34 	GND34   CGND 		TSSOP48_34
X_PIN_35 	B6      P_B6 		TSSOP48_35
X_PIN_36 	B5      P_B5 		TSSOP48_36
X_PIN_37 	B4      P_B4 		TSSOP48_37
X_PIN_38 	B3      P_B3 		TSSOP48_38
X_PIN_39 	GND39   CGND 		TSSOP48_39
X_PIN_40 	B2      P_B2 		TSSOP48_40
X_PIN_41 	B1      P_B1 		TSSOP48_41
X_PIN_42 	VCC_CABLE42 CVCC5 	TSSOP48_42
X_PIN_43 	Y13 P_Y13 		TSSOP48_43
X_PIN_44 	Y12 P_Y12 		TSSOP48_44
X_PIN_45 	Y11 P_Y11 		TSSOP48_45
X_PIN_46 	Y10 P_Y10 		TSSOP48_46
X_PIN_47 	Y9 P_Y9 		TSSOP48_47
X_PIN_48 	DIR P_DIR 		TSSOP48_48
 
X_lvcz161284__bit 

+P_HD 
+P_A9 
+P_A10 
+P_A11 
+P_A12 
+P_A13 

+P_A1 
+P_A2 
 
+P_A3 
+P_A4 
+P_A5 
+P_A6 
 
+P_A7 
+P_A8 

+P_PERI_IN 
+P_A14 
+P_A15 
+P_A16 
+P_A17 
+P_HOST_OUT
+P_HOST_IN
+P_C17
+P_C16
+P_C15
+P_C14
+P_PERI_OUT 

+P_B8
+P_B7

+P_B6
+P_B5
+P_B4
+P_B3

+P_B2
+P_B1

+P_Y13
+P_Y12
+P_Y11
+P_Y10
+P_Y9
+P_DIR 
+CVCC
+CVCC5
+CGND

+lvcz161284__bit

.ENDs lvcz161284a

*****THE FOLLOWING IS A TEST TRANSIENT SIMULATION**********
.TRAN         0.5NS 100NS
VDIR       DIR GND DC 0
VHD        HD  GND DC 0
**B1--> A1

VB1	   B1  GND PULSE (0  2.7  5NS  1NS  1NS  50NS  100NS)

C_LOAD_Y9  A1  GND   50p 
R_LOAD_Y9  A1  GND   500
***********************************************************************
***********************************************************************
.temp 40

.END


